#==============================================================================
# ** Classes.Array_2D                                                By: Selwyn
#------------------------------------------------------------------------------
# Two Dimensional Array
#   
#   - by default, resizing the array will destroy the data it contains.
#   - calling any of the following methods of the Array class might mess up
#     the data's indexes, so be careful before using them.
#
#    unshift   uniq!   slice!   shift   reverse!   replace   reject!
#    push   <<    pop   map!   flatten!   fill   delete_if   delete_at
#    delete   concat   compact!   collect!
#
#==============================================================================

MACL::Loaded << 'Classes.Array_2D'

#==============================================================================
# ** Array_2D
#==============================================================================

class Array_2D
  #--------------------------------------------------------------------------
  # * Public Instance Variables
  #--------------------------------------------------------------------------
  attr_reader   :xsize
  attr_reader   :ysize
  #-------------------------------------------------------------------------
  # * Name      : Object Initialization
  #   Info      : Creates a new 2D Array Object
  #   Author    : Selwyn
  #   Call Info : Two Arguments Integer xsize, ysize - dimensions
  #-------------------------------------------------------------------------
  def initialize(xsize, ysize)
    @xsize = xsize
    @ysize = ysize
    make_array
  end
  #-------------------------------------------------------------------------
  # * Name      : Element Reference
  #   Info      : Gets an Element returns Element At ID or X,Y
  #   Author    : Selwyn
  #   Call Info : One-Two Arguments
  #               One - Integer id - id of the element to get
  #               Two - Integer x,y - X and Y.
  #-------------------------------------------------------------------------
  def [](*args)
    case args.size
    when 1
      return @data[args[0]]
    when 2
      return @data[id(*args)]
    end
  end
  #-------------------------------------------------------------------------
  # * Name      : Element Assignment
  #   Info      : Assigns an Object to Element
  #   Author    : Selwyn
  #   Call Info : Two-Three Arguments
  #               Two Integer id - id of the Element to set 
  #                  Object obj - object assigned to id
  #               Three Integer x,y - X and Y.
  #                  Object obj - object assigned to id.
  #-------------------------------------------------------------------------
  def []=(*args)
    case args.size
    when 2
      @data[args[0]] = args[1]
    when 3
      @data[id(args[0], args[1])] = args[2]
    end
  end
  #-------------------------------------------------------------------------
  # * Name      : Set X Size
  #   Info      : Sets Width of 2D Array
  #   Author    : Selwyn
  #   Call Info : One or Two - Integer xsize - new size 
  #               Boolean clear - clears array
  #-------------------------------------------------------------------------
  def xsize=(xsize, clear = true)
    @xsize = xsize
    make_array if clear
  end
  #-------------------------------------------------------------------------
  # * Name      : Set Y Size
  #   Info      : Sets Height of 2D Array
  #   Author    : Selwyn
  #   Call Info : One or Two - Integer ysize - new size 
  #               Boolean clear - clears array
  #-------------------------------------------------------------------------
  def ysize=(ysize, clear = true)
    @ysize = ysize
    make_array if clear
  end
  #-------------------------------------------------------------------------
  # * Name      : Set Size
  #   Info      : Sets Dimensions of 2D Array
  #   Author    : Selwyn
  #   Call Info : Two or Three - Integer xsize, ysize - Dimensions
  #               Boolean clear - clears array
  #-------------------------------------------------------------------------
  def resize(xsize, ysize, clear = true)
    @xsize = xsize
    @ysize = ysize
    make_array if clear
  end
  #-------------------------------------------------------------------------
  # * Name      : Make Array
  #   Info      : Creates Data Array
  #   Author    : Selwyn
  #   Call Info : No Arguments
  #-------------------------------------------------------------------------
  def make_array
    max = id(@xsize, @ysize)
    @data = nil
    @data = Array.new(max)
  end
  #-------------------------------------------------------------------------
  # * Name      : ID
  #   Info      : Retunrs id of element
  #   Author    : Selwyn
  #   Call Info : Two Arguments Integer X and Y
  #-------------------------------------------------------------------------
  def id(x, y)
    return x + y * (@xsize + 1)
  end
  #-------------------------------------------------------------------------
  # * Name      : Coord
  #   Info      : Gets Coordinates returns Array - [x, y]
  #   Author    : Selwyn
  #   Call Info : One Integer ID, Id to get coordinates from
  #-------------------------------------------------------------------------
  def coord(id)
    x = id % (@xsize + 1)
    y = id / (@xsize + 1)
    return x, y
  end
  #--------------------------------------------------------------------------
  # * All other Array methods
  #--------------------------------------------------------------------------
  def method_missing(symbol, *args)
    @data.method(symbol).call(*args)
  end
end